import { world, MolangVariableMap } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:torches', {
        onRandomTick(e) {
            const { block } = e
            if (block.typeId === 'v360:copper_torch') {
                const blockFace = block.permutation.getState('minecraft:block_face')
                const particlePositions = {
                    north: [0.5, 0.9, 0.75],
                    south: [0.5, 0.9, 0.25],
                    east: [0.25, 0.9, 0.5],
                    west: [0.75, 0.9, 0.5],
                    up: [0.5, 0.7, 0.5]
                }
                const position = particlePositions[blockFace]
                if (position) {
                    const [offsetX, offsetY, offsetZ] = position
                    const { x, y, z } = block.location
                    const particleX = x + offsetX
                    const particleY = y + offsetY
                    const particleZ = z + offsetZ
                    const molangVariables = new MolangVariableMap()
                    block.dimension.spawnParticle('v360:copper_flame_particle', { x: particleX, y: particleY, z: particleZ }, molangVariables)
                    block.dimension.spawnParticle('minecraft:basic_smoke_particle', { x: particleX, y: particleY, z: particleZ }, molangVariables)
                }
            }
        }
    });
});